#include <stdio.h>		/* For printf */
#include "e1432.h"

/* Wrap this around all the many function calls which might fail */
#define DEBUG(s)        s
#ifdef  __lint
#define CHECK(func)     \
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
        DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
        return _s;\
    }\
} while (func)
#else
#define CHECK(func)     \
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
        DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
        return _s;\
    }\
} while (0)
#endif

FLOATSIZ64 buffer[1024];

int
main(void)
{
    struct e1432_hwconfig hwconfig[2];
    int     i, j, ch, nchan, status;
    LONGSIZ32 count;
    SHORTSIZ16 laddr[2];
    SHORTSIZ16 chan_list[32 + 2];
    SHORTSIZ16 group;
    FLOATSIZ32 fs;
    E1432ID hw;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    e1432_set_try_recover(0);
    e1432_trace_level(0);
    e1432_debug_level(0);

    laddr[0] = 8;
    laddr[1] = 9;

    (void) printf("install...\n");
    for (i = 0; i < 2; i++)
    {
	CHECK(e1432_print_errors(0));
	status = e1432_get_hwconfig(1, laddr + i, hwconfig + i);
	CHECK(e1432_print_errors(1));
	if (status < 0)
	    CHECK(e1432_install(1, laddr + i, 0, "/e1432/lib/sema.bin"));
    }

#if 1
    for (i = 0; i < 2; i++)
    {
	CHECK(e1432_get_hwconfig(1, laddr + i, hwconfig + i));
    }
    (void) printf("Logical address %d:\n", laddr[0]);
    (void) printf("man_id       = 0x%x\n", hwconfig[0].man_id);
    (void) printf("model_code   = 0x%x\n", hwconfig[0].model_code);
    (void) printf("hw_rev       = %d\n", hwconfig[0].hw_rev);
    (void) printf("bootrom_rev  = %d\n", hwconfig[0].bootrom_rev);
    (void) printf("fw_rev       = %ld\n", hwconfig[0].fw_rev);
    (void) printf("sca_id[0]    = %d\n", hwconfig[0].sca_id[0]);
    (void) printf("sca_id[1]    = %d\n", hwconfig[0].sca_id[1]);
    (void) printf("sca_id[2]    = %d\n", hwconfig[0].sca_id[2]);
    (void) printf("sca_id[3]    = %d\n", hwconfig[0].sca_id[3]);
    (void) printf("sca_id[4]    = %d\n", hwconfig[0].sca_id[4]);
    (void) printf("sca_rev[0]   = %d\n", hwconfig[0].sca_rev[0]);
    (void) printf("sca_rev[1]   = %d\n", hwconfig[0].sca_rev[1]);
    (void) printf("sca_rev[2]   = %d\n", hwconfig[0].sca_rev[2]);
    (void) printf("sca_rev[3]   = %d\n", hwconfig[0].sca_rev[3]);
    (void) printf("sca_rev[4]   = %d\n", hwconfig[0].sca_rev[4]);
    (void) printf("bob_id[0]    = %d\n", hwconfig[0].bob_id[0]);
    (void) printf("bob_id[1]    = %d\n", hwconfig[0].bob_id[1]);
    (void) printf("bob_id[2]    = %d\n", hwconfig[0].bob_id[2]);
    (void) printf("bob_id[3]    = %d\n", hwconfig[0].bob_id[3]);
    (void) printf("bob_id[4]    = %d\n", hwconfig[0].bob_id[4]);
    (void) printf("total_chans  = %d\n", hwconfig[0].total_chans);
    (void) printf("input_chans  = %d\n", hwconfig[0].input_chans);
    (void) printf("source_chans = %d\n", hwconfig[0].source_chans);
    (void) printf("tach_chans   = %d\n", hwconfig[0].tach_chans);
    (void) printf("lbus_present = %d\n", hwconfig[0].lbus_present);
    (void) printf("dram_size    = 0x%lx\n", hwconfig[0].dram_size);
    (void) printf("a24_used     = 0x%lx\n", hwconfig[0].a24_used);
    (void) printf("serial       = %s\n", hwconfig[0].serial);
    (void) printf("\n");
    (void) printf("Logical address %d:\n", laddr[1]);
    (void) printf("man_id       = 0x%x\n", hwconfig[1].man_id);
    (void) printf("model_code   = 0x%x\n", hwconfig[1].model_code);
    (void) printf("hw_rev       = %d\n", hwconfig[1].hw_rev);
    (void) printf("bootrom_rev  = %d\n", hwconfig[1].bootrom_rev);
    (void) printf("fw_rev       = %ld\n", hwconfig[1].fw_rev);
    (void) printf("sca_id[0]    = %d\n", hwconfig[1].sca_id[0]);
    (void) printf("sca_id[1]    = %d\n", hwconfig[1].sca_id[1]);
    (void) printf("sca_id[2]    = %d\n", hwconfig[1].sca_id[2]);
    (void) printf("sca_id[3]    = %d\n", hwconfig[1].sca_id[3]);
    (void) printf("sca_id[4]    = %d\n", hwconfig[1].sca_id[4]);
    (void) printf("sca_rev[0]   = %d\n", hwconfig[1].sca_rev[0]);
    (void) printf("sca_rev[1]   = %d\n", hwconfig[1].sca_rev[1]);
    (void) printf("sca_rev[2]   = %d\n", hwconfig[1].sca_rev[2]);
    (void) printf("sca_rev[3]   = %d\n", hwconfig[1].sca_rev[3]);
    (void) printf("sca_rev[4]   = %d\n", hwconfig[1].sca_rev[4]);
    (void) printf("bob_id[0]    = %d\n", hwconfig[1].bob_id[0]);
    (void) printf("bob_id[1]    = %d\n", hwconfig[1].bob_id[1]);
    (void) printf("bob_id[2]    = %d\n", hwconfig[1].bob_id[2]);
    (void) printf("bob_id[3]    = %d\n", hwconfig[1].bob_id[3]);
    (void) printf("bob_id[4]    = %d\n", hwconfig[1].bob_id[4]);
    (void) printf("total_chans  = %d\n", hwconfig[1].total_chans);
    (void) printf("input_chans  = %d\n", hwconfig[1].input_chans);
    (void) printf("source_chans = %d\n", hwconfig[1].source_chans);
    (void) printf("tach_chans   = %d\n", hwconfig[1].tach_chans);
    (void) printf("lbus_present = %d\n", hwconfig[1].lbus_present);
    (void) printf("dram_size    = 0x%lx\n", hwconfig[1].dram_size);
    (void) printf("a24_used     = 0x%lx\n", hwconfig[1].a24_used);
    (void) printf("serial       = %s\n", hwconfig[1].serial);
#endif

    CHECK(e1432_assign_channel_numbers(2, laddr, &hw));

    /* Create channel group */
    nchan = hwconfig[0].input_chans + hwconfig[1].input_chans;

    for (ch = 1; ch <= nchan; ch++)
	chan_list[ch - 1] = E1432_INPUT_CHAN(ch);

    group = e1432_create_channel_group(hw, nchan, chan_list);
    if (group >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    group));
	return -1;
    }

    CHECK(e1432_get_clock_freq(hw, group, &fs));
    CHECK(e1432_preset(hw, group));
    CHECK(e1432_set_data_size(hw, group, E1432_DATA_SIZE_32));
    CHECK(e1432_set_auto_arm(hw, group, E1432_AUTO_ARM));
    CHECK(e1432_init_measure(hw, group));
    CHECK(e1432_set_span(hw, group, .99F * 20000.0F));
    CHECK(e1432_set_center_freq(hw, group, 0.0F));
    CHECK(e1432_set_blocksize(hw, group, 512));
    CHECK(e1432_set_data_mode(hw, group, E1432_BLOCK_MODE));

    /* Initialize hardware things */
    for (i = 0; i < nchan; i++)
	CHECK(e1432_set_analog_input(hw, chan_list[i],
				     E1432_INPUT_MODE_VOLT,
				     E1432_INPUT_HIGH_NORMAL,
				     E1432_ANTI_ALIAS_ANALOG_ON,
				     E1432_COUPLING_DC, 1.0F));

    {
	FLOATSIZ32 range;

	CHECK(e1432_set_range(hw, chan_list[0], 0.1F));
	CHECK(e1432_get_range(hw, chan_list[0], &range));
	(void) printf("Got back range %f\n", range);
    }

    /* Start measurement */
    CHECK(e1432_init_measure(hw, group));

    for (j = 1; j <= 4; j++)
    {
	/* Wait for block available */
	while ((status = e1432_block_available(hw, group)) == 0);
	if (status > 0)
	    (void) printf("Block available found! %d\n", j);
	else
	{
	    DEBUG((void) printf("Error %d from e1432_block_available\n",
				status));
	    return -1;
	}

	/* Read some data */
	for (i = 0; i < nchan; i++)
	{
	    /* Read some data */
	    CHECK(e1432_read_float64_data(hw, chan_list[i],
					  E1432_TIME_DATA, buffer,
					  512, NULL, &count));
	    if (count != 512)
	    {
		DEBUG((void) printf("Actual count was %d\n", count));
		return -1;
	    }
	}
    }

    CHECK(e1432_init_measure(hw, group));

    (void) printf("done\n");
    return 0;
}
